  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 17 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_ATP_ReadOnlyData.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include <stdio.h>
#include "SST_SEP_TST.h"
#include "CRYS_SST.h" 
#include "SEP_ATP_UTIL_funcs.h"

extern TST_ATP_DataOpTestDataStruct* TST_ATP_DataOpTestData;
/*****************************************************************************
 * Function Name:
 *  SST_TST_ATP_ReadOnlyData
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the creation, deletion, modification, opening, closing and usage of a password authenticator object. 
 * And demonstrate the use of transaction with authenticator objects
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd. 
 *    5.  Open the new authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Insert a new data object by calling: SST_InsertData.
 *    8.    Set the data to read only by calling: SST_DataReadOnlySet
 *    8.  Close the transaction by calling: SST_TransactionEnd.
 *    9.  Read and compare the inserted data by calling: SST_ReadData.
 *    10.  Open a transaction by calling: SST_TransactionStart.
 *    11.  Try to Modify the data from selected location by calling: SST_ModifyData. this should fail!!
 *    12.  Try to delete the data by calling: SST_DeleteData. this should fail!!
 *    13.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    14.  Close the transaction by calling: SST_TransactionClose.
 *    15.  Delete the session by calling: SST_SessionDelete.
 *                            
 ********************************************************************************/    
DxError_t SEPQA_SST_ReadOnlyData ( void )
{
    /********* TST Variables Definitions ************/
    DxUint32_t          TST_index=0;
    DxChar              TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_ReadOnlyData";
    SSTSessionId_t      TST_SessionId; 
    SSTTxnId_t          TST_TransactionId;
    SSTHandle_t         TST_AuthHandle,TST_DataHandle;
    SSTDataType_t       TST_SimpleData = TST_READ_ONLY_DATA_OBJECT;
    DxUint32_t          TST_TempDataSize;
    SSTHandle_t         TST_AuthDefaultHandle;
    DxError_t           TST_Status;

    /********* TST Variables initialization *********/
    TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
    TST_DataHandle.objId = SST_HANDLE_RANDOM_GENERATE;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ********** SST_TST_ATP_ReadOnlyData Tests ************ \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));



    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));


    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Create a new password authenticator */
    /*-------------------------------------*/
    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                 TST_SessionId,
                                                 TST_ATP_DataOpTestData[TST_index].TST_Password,
                                                 TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                                 TST_ATP_DataOpTestData[TST_index].TST_MaxNumOfTrials,
                                                 TST_AuthDefaultHandle,
                                                 &TST_AuthHandle,
                                                 TST_Workspace,
                                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open the password authentication */
    /*----------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_DataOpTestData[TST_index].TST_Password,
                                        TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                        TST_NO_CHALLENGE,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Password",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_DataHandle.objId = TST_index;
printf("\n TST_ATP_DataOpTestData[TST_index].TST_DataSize is %d \n",TST_ATP_DataOpTestData[TST_index].TST_DataSize);
    /* Insert a new Data object */
    /*--------------------------*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                                TST_SessionId,
                                TST_AuthHandle,
                                TST_ATP_DataOpTestData[TST_index].TST_Data,
                                TST_ATP_DataOpTestData[TST_index].TST_DataSize,
                                DX_TRUE,
                                TST_SimpleData,
                                &TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Set the data to Read Only */
    /*---------------------------*/
    TST_Status = SST_DataReadOnlySet(TST_TransactionId,
                                     TST_SessionId,
                                     TST_DataHandle,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataReadOnlySet",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);



    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Read the data */
    /*---------------*/
    TST_TempDataSize = TST_ATP_DataOpTestData[TST_index].TST_DataSize;

    TST_Status = SST_DataRead(TST_SessionId,
                              TST_DataHandle,
                              TST_ATP_DataOpTestData[TST_index].TST_DataReadOffset,
                              TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                              &TST_TempDataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Compare the retrieved data to the original */
    /*--------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_ATP_DataOpTestData[TST_index].TST_Data,
                      TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                      TST_ATP_DataOpTestData[TST_index].TST_DataSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Original data",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);




    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Try to Modify the data from selected location - this operation should fail!! */
    /*------------------------------------------------------------------------------*/
    TST_Status = SST_DataModify(TST_TransactionId,
                                TST_SessionId,
                                TST_DataHandle,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWrite,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWriteSize,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWriteOffset,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_Status = TST_CheckExpectedErrorReturn(TST_Status,
                                              SST_RC_ERROR_ACCESS_DENIED,
                                              "SST_DataModify",
                                              TST_ATP_DataOpTestData[TST_index].TST_Name,
                                              TST_MasterTestName);
    #if SST_TST_EXIT_ON_ERROR
        if (TST_Status != TESTPASS)
            goto EXIT_ON_ERROR;
    #endif

    /* Try to Delete the data  - This operation should fail!! */
    /*--------------------------------------------------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,
                                TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_Status = TST_CheckExpectedErrorReturn(TST_Status,
                                              SST_RC_ERROR_ACCESS_DENIED,
                                              "SST_DataDelete",
                                              TST_ATP_DataOpTestData[TST_index].TST_Name,
                                              TST_MasterTestName);

    #if SST_TST_EXIT_ON_ERROR
        if (TST_Status != TESTPASS)
            goto EXIT_ON_ERROR;
    #endif

    /* Delete the authenticator - this should fail as the authenticator is connected to data */
    /*---------------------------------------------------------------------------------------*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandle);

    TST_Status = TST_CheckExpectedErrorReturn(TST_Status,
                                              SST_RC_ERROR_ACCESS_DENIED,
                                              "SST_AuthenticatorDelete",
                                 TST_ATP_DataOpTestData[TST_index].TST_Name,
                                 TST_MasterTestName);
    #if SST_TST_EXIT_ON_ERROR
      if (TST_Status != TESTPASS)
        goto EXIT_ON_ERROR;
    #endif

    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               TST_ATP_DataOpTestData[TST_index].TST_Name,
                               TST_MasterTestName);



  EXIT_ON_ERROR:


    return TST_Status;

}/* End of SST_TST_ATP_ReadOnlyData */

